/****************************************************************************
 **                                                                        **
 **  Vector manipulations / object primivite scannings - Aron, 1998.05.22  **
 **                                                                        **
 ****************************************************************************/


// - alapveto vektormuveletek -----------------------------------------------
void NormalizeVector(VECTOR *v)
{ float length= (float)sqrt(v->X*v->X + v->Y*v->Y + v->Z*v->Z);

  // normalas:
  v->X/= length; v->Y/= length; v->Z/= length;
}

float DotProductVectors(VECTOR *v0,VECTOR *v1)
{ return (v0->X*v1->X + v0->Y*v1->Y + v0->Z*v1->Z);
}

void CrossProductVectors(VECTOR *v_result,VECTOR *v0,VECTOR *v1)
{ // vektorialis szorzas:
  v_result->X= (v0->Y * v1->Z) - (v0->Z * v1->Y);
  v_result->Y= (v0->Z * v1->X) - (v0->X * v1->Z);
  v_result->Z= (v0->X * v1->Y) - (v0->Y * v1->X);
}

// - objektumprimitivek inicializalo rutinjai -------------------------------
void InitPlane(OBJECT *plane)
{ // nincs prekalkulalhato adat:
}

void InitSphere(OBJECT *sphere)
{ // nincs prekalkulalhato adat:
}

void InitCylinder(OBJECT *cylinder)
{ CYLINDER *cylinderdataptr= (CYLINDER *)cylinder->data;

  // AXIS tengelyvektor prekalkulalhato:
  cylinderdataptr->axis.X= cylinderdataptr->B.X - cylinderdataptr->A.X;
  cylinderdataptr->axis.Y= cylinderdataptr->B.Y - cylinderdataptr->A.Y;
  cylinderdataptr->axis.Z= cylinderdataptr->B.Z - cylinderdataptr->A.Z;

  // AXIS hosszanak negyzete prekalkulalhato:
  cylinderdataptr->axis2= DotProductVectors(&cylinderdataptr->axis,&cylinderdataptr->axis);
}

void InitPolygon(OBJECT *polygon)
{ VECTOR a,b;
  float s;
  POLYGON *polygondataptr= (POLYGON *)polygon->data;

  // lapnormalis prekalkulalhato:
  a.X= polygondataptr->B.X - polygondataptr->A.X;
  a.Y= polygondataptr->B.Y - polygondataptr->A.Y;
  a.Z= polygondataptr->B.Z - polygondataptr->A.Z;

  b.X= polygondataptr->C.X - polygondataptr->A.X;
  b.Y= polygondataptr->C.Y - polygondataptr->A.Y;
  b.Z= polygondataptr->C.Z - polygondataptr->A.Z;

  CrossProductVectors(&polygondataptr->normal,&a,&b);
  NormalizeVector(&polygondataptr->normal);

  // B1/B2:
  CrossProductVectors(&polygondataptr->B1,&b,&polygondataptr->normal);
  s= 1.0f / DotProductVectors(&polygondataptr->B1,&a);
  polygondataptr->B1.X*= s;
  polygondataptr->B1.Y*= s;
  polygondataptr->B1.Z*= s;

  CrossProductVectors(&polygondataptr->B2,&polygondataptr->normal,&a);
  polygondataptr->B2.X*= s;
  polygondataptr->B2.Y*= s;
  polygondataptr->B2.Z*= s;
}

void (*InitObject[OBJECT_PRIMITIVES])(OBJECT *)=
                                    { InitPlane,
                                      InitSphere,
                                      InitCylinder,
                                      InitPolygon
                                    };

// - objektumprimitivek metszespontkereso rutinjai --------------------------
byte DetectPlane(RAY *ray,OBJECT *plane,INTERSECTION *intersection,byte flag)
{ float t;
  PLANE *planedataptr= (PLANE *)plane->data;

  // a sik_normalisanak es a sugar_iranyvektoranak skalaris szorzata:
  if(ray->D.Y > 0.0) return 0;         // nincs metszes

  // t parameter:
  t= -(ray->Pstart.Y + planedataptr->onepoint.Y)/ray->D.Y;
  if(t <= 0.0) return 0;

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { if(t < intersection->t)
    { intersection->t= t;
      intersection->objectptr= plane;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // a sik normalvektora:
      intersection->normal.X= 0.0;
      intersection->normal.Y= 1.0;
      intersection->normal.Z= 0.0;
      // texturamutato es felulettipus beallitasa:
      intersection->textureptr= plane->textureptr;
      intersection->surfacetype= plane->surfacetype;
      // planar mapping:
      intersection->U= ((dword)intersection->point.X) % 256;
      intersection->V= ((dword)intersection->point.Z) % 256;
    }
  }

  // volt metszespont:
  return 1;
}

byte DetectSphere(RAY *ray,OBJECT *sphere,INTERSECTION *intersection,byte flag)
{ float b,disc,t;
  VECTOR V;
  SPHERE *spheredataptr= (SPHERE *)sphere->data;

  // V:= gomb_kozepponja - sugar_kezdopontja;
  V.X= spheredataptr->center.X - ray->Pstart.X;
  V.Y= spheredataptr->center.Y - ray->Pstart.Y;
  V.Z= spheredataptr->center.Z - ray->Pstart.Z;

  // b:= V es a sugar_iranyvektoranak skalaris szorzata
  b= DotProductVectors(&V,&ray->D);

  // diszkriminans:
  disc= b*b - (V.X*V.X + V.Y*V.Y + V.Z*V.Z) + spheredataptr->radius*spheredataptr->radius;
  if(disc < 0) return 0;                  // nincs metszes

  // t parameter a flip-pelest figyelembe vege:
  disc= (float)sqrt(disc); if(sphere->surfacetype & FLIPPED) disc= -disc;
  t= b - disc;
  if(t <= 0.0) return 0;

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { if(t < intersection->t)
    { intersection->t= t;
      intersection->objectptr= sphere;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // a gomb normalvektora a metszesi pontban:
      intersection->normal.X= (intersection->point.X - spheredataptr->center.X) / spheredataptr->radius;
      intersection->normal.Y= (intersection->point.Y - spheredataptr->center.Y) / spheredataptr->radius;
      intersection->normal.Z= (intersection->point.Z - spheredataptr->center.Z) / spheredataptr->radius;
      if(sphere->surfacetype & FLIPPED)
      { intersection->normal.X= -intersection->normal.X;
        intersection->normal.Y= -intersection->normal.Y;
        intersection->normal.Z= -intersection->normal.Z;
      }
      // texturamutato es felulettipus beallitasa:
      intersection->textureptr= sphere->textureptr;
      intersection->surfacetype= sphere->surfacetype;
      // gyorsitott spherical mapping:
      intersection->U= (dword)(128.0f + 127.0f*intersection->normal.X);
      intersection->V= (dword)(128.0f + 127.0f*intersection->normal.Y);
    }
  }

  // volt metszespont:
  return 1;
}

byte DetectCylinder(RAY *ray,OBJECT *cylinder,INTERSECTION *intersection,byte flag)
{ VECTOR work1,work2;
  float aa,bb,a,b,c,disc,t,p;
  CYLINDER *cylinderdataptr= (CYLINDER *)cylinder->data;

  work1.X= ray->Pstart.X - cylinderdataptr->A.X;
  work1.Y= ray->Pstart.Y - cylinderdataptr->A.Y;
  work1.Z= ray->Pstart.Z - cylinderdataptr->A.Z;

  // aa= <work1,cylinder->axis> / cylinder->axis
  aa= DotProductVectors(&work1,&cylinderdataptr->axis) / cylinderdataptr->axis2;
  work1.X= ray->Pstart.X - aa*cylinderdataptr->axis.X - cylinderdataptr->A.X;
  work1.Y= ray->Pstart.Y - aa*cylinderdataptr->axis.Y - cylinderdataptr->A.Y;
  work1.Z= ray->Pstart.Z - aa*cylinderdataptr->axis.Z - cylinderdataptr->A.Z;

  // bb= <ray,cylinder->axis> / cylinder->axis
  bb= DotProductVectors(&ray->D,&cylinderdataptr->axis) / cylinderdataptr->axis2;
  work2.X= ray->D.X - bb*cylinderdataptr->axis.X;
  work2.Y= ray->D.Y - bb*cylinderdataptr->axis.Y;
  work2.Z= ray->D.Z - bb*cylinderdataptr->axis.Z;

  a= 2.0f*DotProductVectors(&work2,&work2);
  b= 2.0f*DotProductVectors(&work1,&work2);
  c= DotProductVectors(&work1,&work1) - cylinderdataptr->radius*cylinderdataptr->radius;

  // diszkriminans:
  disc= b*b - 2.0f*a*c;
  if(disc < 0.0f) return 0; // nincs metszes

  // t parameter a flip-pelest figyelembe veve
  disc= (float)sqrt(disc);
  if(cylinder->surfacetype & FLIPPED) disc= -disc;        // flip-peles
  t= (-b - disc) / a;
  if(t <= 0.0) return 0;
  p= aa + t*bb;
  if((p <= 0.0) || (p >= 1.0)) return 0;

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { if(t < intersection->t)
    { intersection->t= t;
      intersection->objectptr= cylinder;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // a henger normalvektora a metszesi pontban:
      intersection->normal.X= (intersection->point.X - (cylinderdataptr->A.X + p*cylinderdataptr->axis.X)) / cylinderdataptr->radius;
      intersection->normal.Y= (intersection->point.Y - (cylinderdataptr->A.Y + p*cylinderdataptr->axis.Y)) / cylinderdataptr->radius;
      intersection->normal.Z= (intersection->point.Z - (cylinderdataptr->A.Z + p*cylinderdataptr->axis.Z)) / cylinderdataptr->radius;
      if(cylinder->surfacetype & FLIPPED)
      { intersection->normal.X= -intersection->normal.X;
        intersection->normal.Y= -intersection->normal.Y;
        intersection->normal.Z= -intersection->normal.Z;
      }
      // texturamutato es felulettipus beallitasa:
      intersection->textureptr= cylinder->textureptr;
      intersection->surfacetype= cylinder->surfacetype;
      // gyorsitott cylindrical mapping:
      intersection->U= (dword)(128.0f + 127.0f*intersection->normal.X);
      intersection->V= (dword)(255.0f*p);
    }
  }

  // volt metszespont:
  return 1;
}

byte DetectPolygon(RAY *ray,OBJECT *polygon,INTERSECTION *intersection,byte flag)
{ VECTOR work;
  float numer,denom,p,q,t;
  POLYGON *polygondataptr= (POLYGON *)polygon->data;

  work.X= ray->Pstart.X - polygondataptr->A.X;
  work.Y= ray->Pstart.Y - polygondataptr->A.Y;
  work.Z= ray->Pstart.Z - polygondataptr->A.Z;

  numer= DotProductVectors(&work,&polygondataptr->normal);
  denom= DotProductVectors(&ray->D,&polygondataptr->normal);

  // t parameter:
  if(denom == 0.0) return 0;
  t= -numer / denom;

  work.X= ray->Pstart.X + t*ray->D.X - polygondataptr->A.X;
  work.Y= ray->Pstart.Y + t*ray->D.Y - polygondataptr->A.Y;
  work.Z= ray->Pstart.Z + t*ray->D.Z - polygondataptr->A.Z;

  // metszespont vizsgalat (haromszog/negyszog):
  p= DotProductVectors(&work,&polygondataptr->B1);
  if((p < 0.0) || (p > 1.0)) return 0;
  q= DotProductVectors(&work,&polygondataptr->B2);
  if((q < 0.0) || (q > 1.0)) return 0;

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { if(t < intersection->t)
    { intersection->t= t;
      intersection->objectptr= polygon;
      // metszespont:
      intersection->point.X= work.X - polygondataptr->A.X;
      intersection->point.Y= work.Y - polygondataptr->A.Y;
      intersection->point.Z= work.Z - polygondataptr->A.Z;
      // a poligon normalvektora a metszesi pontban (face/backface):
      intersection->normal.X= polygondataptr->normal.X;
      intersection->normal.Y= polygondataptr->normal.Y;
      intersection->normal.Z= polygondataptr->normal.Z;
      // texturamutato es felulettipus beallitasa:
      intersection->textureptr= polygon->textureptr;
      intersection->surfacetype= polygon->surfacetype;
      // planar mapping:
      intersection->U= (dword)(255.0*p);
      intersection->V= (dword)(255.0*q);
    }
  }

  // volt metszespont:
  return 1;
}

byte (*DetectObject[OBJECT_PRIMITIVES])(RAY *,OBJECT *,INTERSECTION *,byte)=
                                    { DetectPlane,
                                      DetectSphere,
                                      DetectCylinder,
                                      DetectPolygon
                                    };